Option Strict On
Option Explicit On
Imports System.Collections.Generic
Imports System.Runtime.InteropServices
Imports System.Text
Imports text_coordinates2.DynaPDF

Friend Class CTextCoordinates

   Public Structure TGState
      Dim ActiveFont As IntPtr
      Dim CharSpacing As Single
      Dim FontSize As Double
      Dim FontType As TFontType
      Dim Matrix As TCTM
      Dim TextDrawMode As TDrawMode
      Dim TextScale As Single
      Dim WordSpacing As Single
   End Structure

   Protected Class CStack
      Protected Overrides Sub Finalize()
         m_Items = Nothing
      End Sub

      Public Function Restore(ByRef F As TGState) As Boolean
         If m_Count > 0 Then
            m_Count -= 1
            F = m_Items(m_Count)
            Return True
         End If
         Return False
      End Function

      Public Function Save(ByRef F As TGState) As Integer
         If m_Count = m_Capacity Then
            m_Capacity += 16
            Try
               ReDim m_Items(m_Capacity)
            Catch
               m_Capacity -= 16
               Return -1
            End Try
         End If
         m_Items(m_Count) = F
         m_Count += 1
         Return 0
      End Function
      Private m_Capacity As Integer
      Private m_Count As Integer
      Private m_Items As TGState()
   End Class

   Public Sub New(ByVal PDFInst As CPDF)
      m_GState.ActiveFont = IntPtr.Zero
      m_GState.CharSpacing = 0.0F
      m_GState.FontSize = 1.0
      m_GState.FontType = TFontType.ftType1
      m_GState.Matrix.a = 1.0
      m_GState.Matrix.b = 0.0
      m_GState.Matrix.c = 0.0
      m_GState.Matrix.d = 1.0
      m_GState.Matrix.x = 0.0
      m_GState.Matrix.y = 0.0
      m_GState.TextDrawMode = TDrawMode.dmNormal
      m_GState.TextScale = 100.0F
      m_GState.WordSpacing = 0.0F
      m_PDF = PDFInst
      m_Stack = New CStack()
   End Sub

   Public Function BeginTemplate(ByVal BBox As TPDFRect, ByVal Matrix As IntPtr) As Integer
      Reset()
      If Not IntPtr.Zero.Equals(Matrix) Then
         Dim m As TCTM
         m = CType(Marshal.PtrToStructure(Matrix, GetType(TCTM)), TCTM)
         m_GState.Matrix = MulMatrix(m_GState.Matrix, m)
      End If
      Return 0
   End Function

   Protected Function CalcDistance(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double) As Double
      Dim dx As Double = x2 - x1
      Dim dy As Double = y2 - y1
      Return Math.Sqrt(dx * dx + dy * dy)
   End Function

   Public Function AddText(ByRef TextArray As List(Of TTextRec), ByVal Matrix As TCTM, ByVal Source() As TTextRecordA, ByVal Kerning() As TTextRecordW, ByVal Count As Integer, ByVal Width As Double, ByVal Decoded As Boolean) As Integer
      If Not Decoded Then Return 0
      Try
         Dim i As Integer
         Dim txt As New TText
         Dim rec As New TTextRec
         Dim k As TTextRecordW
         Dim x1 As Double, y1 As Double, x2 As Double, y2 As Double
         ' Transform the text matrix to user space
         Dim m As TCTM = MulMatrix(m_GState.Matrix, Matrix)
         x1 = 0.0
         y1 = 0.0
         Transform(m, x1, y1) ' Start point of the text record
         x2 = 0.0
         y2 = m_GState.FontSize
         Transform(m, x2, y2)

         ReDim rec.Text(Kerning.Length - 1)
         For i = 0 To CInt(Kerning.Length - 1)
            k = Kerning(i)
            txt.Advance = k.Advance
            txt.Width = k.Width
            txt.Text = Marshal.PtrToStringUni(k.Text, k.Length)
            rec.Text(i) = txt
         Next
         rec.X = System.Convert.ToSingle(x1)
         rec.Y = System.Convert.ToSingle(y1)
         rec.FontSize = System.Convert.ToSingle(CalcDistance(x1, y1, x2, y2))
         rec.SpaceWidth = m_SpaceWidth
         rec.Width = System.Convert.ToSingle(Width)
         TextArray.Add(rec)
         Return 0
      Catch
         Return -1
      End Try
   End Function

   Public Sub Init()
      Do While RestoreGState()
      Loop
      m_GState.ActiveFont = IntPtr.Zero
      m_GState.CharSpacing = 0.0F
      m_GState.FontSize = 1.0
      m_GState.Matrix.a = 1.0
      m_GState.Matrix.b = 0.0
      m_GState.Matrix.c = 0.0
      m_GState.Matrix.d = 1.0
      m_GState.Matrix.x = 0.0
      m_GState.Matrix.y = 0.0
      m_GState.TextDrawMode = TDrawMode.dmNormal
      m_GState.TextScale = 100.0F
      m_GState.WordSpacing = 0.0F
   End Sub

   Public Sub MulMatrix(ByVal M As TCTM)
      m_GState.Matrix = MulMatrix(m_GState.Matrix, M)
   End Sub

   Protected Function MulMatrix(ByVal M1 As TCTM, ByVal M2 As TCTM) As TCTM
      Dim retval As TCTM
      retval.a = M2.a * M1.a + M2.b * M1.c
      retval.b = M2.a * M1.b + M2.b * M1.d
      retval.c = M2.c * M1.a + M2.d * M1.c
      retval.d = M2.c * M1.b + M2.d * M1.d
      retval.x = M2.x * M1.a + M2.y * M1.c + M1.x
      retval.y = M2.x * M1.b + M2.y * M1.d + M1.y
      Return retval
   End Function

   Public Function RestoreGState() As Boolean
      If Not m_Stack.Restore(m_GState) Then Return False
      If m_GState.ActiveFont <> IntPtr.Zero Then
         m_SpaceWidth = Convert.ToSingle(m_PDF.GetSpaceWidth(m_GState.ActiveFont, m_GState.FontSize))
      End If
      Return True
   End Function

   Public Function SaveGState() As Integer
      Return m_Stack.Save(m_GState)
   End Function

   Public Sub SetFont(ByVal FontSize As Double, ByVal Type As TFontType, ByVal Font As IntPtr)
      m_GState.ActiveFont = Font
      m_GState.FontSize = FontSize
      m_GState.FontType = Type
      m_SpaceWidth = Convert.ToSingle(m_PDF.GetSpaceWidth(Font, FontSize))
   End Sub

   Protected Sub Transform(ByRef M As TCTM, ByRef x As Double, ByRef y As Double)
      Dim tx As Double
      tx = x
      x = tx * M.a + y * M.c + M.x
      y = tx * M.b + y * M.d + M.y
   End Sub

   Protected m_Count As Integer
   Protected m_GState As TGState
   Protected m_PDF As CPDF
   Protected m_SpaceWidth As Single
   Protected m_Stack As CStack
End Class
